% Get the eigenvectors
% Evolve wavefunction from initial point (lower triangle corner) to the
% measurement node
% ------------------------------------------------------------------------

function amp = get_g0_mech_cav_gray(kpeak, scat, dis, tri, ...
    vel, g0peak)

% Extra distance such that the wavefunction is set to zero at a distance of
% amech from first site
dis_extra = (1 - rem(tri.Leff_corr,1)/2)*tri.amech_corr;

% Eigenvectors
evec = zeros(2, size(kpeak, 2));
evec(1,:) = 1;
evec(2,:) = -1;

sol_node = zeros(2, size(kpeak, 2));

% Distance interpretation for translation operator evaluation
quo = floor(dis/(tri.L*tri.amech));
dis_last = rem(dis, tri.L*tri.amech);

% Define all the transfer matrices
T2 = transfer_matrix(scat.r2, scat.t2, 'usual');

for i=1:size(kpeak, 2)
    Twg2 = transfer_matrix(scat.r1, scat.t1, 'waveguide', ...
        kpeak(i)*(tri.L*tri.amech + dis_extra));
    
    % Get normalization constant B
    Twg_mid2 = transfer_matrix(scat.r1, scat.t1, 'waveguide', ...
        kpeak(i)*(tri.L*tri.amech/2 + dis_extra));
    A2 = Twg_mid2*evec(:,i);
    A2 = sum(abs(A2))/2;
    
    B = (2/2*(2*A2^2/vel(i)))^(-1/2);
    
    % Get signal amplitude at the measurement node
    if quo==0
        Twg2 = transfer_matrix(scat.r1, scat.t1, 'waveguide', ...
            kpeak(i)*(dis_last + dis_extra));
        sol_node(:,i) = Twg2*evec(:,i);
        
        prob = g0peak(i)/sqrt(vel(i))*...
            sum(abs(sol_node(:,i)))/2;
    
    elseif quo==1
        Twg3 = transfer_matrix(scat.r1, scat.t1, 'waveguide', ...
            kpeak(i)*dis_last);
        sol_node(:,i) = Twg3*T2*Twg2*evec(:,i);
        
        prob = g0peak(i)/sqrt(vel(i))*...
            sum(abs(sol_node(:,i)))/2;
    else
        sol_node(:,i) = 1; % arbitrary choice
        prob = 0;
    end

    amp(i) = abs(2*pi*B*prob*2*cos(angle(sol_node(2,i)/sol_node(1,i))/2));
   
    
%     disp(A2);
%     disp(sum(abs(sol_node(:,i)))/2);
end

% disp( ['Maximum absolute value of a component of the eigenvector: '...
%         , num2str(max(max(abs(evec))))]  );
% disp( ['Minimum absolute value of a component of the eigenvector: '...
%         , num2str(min(min(abs(evec))))]  );
%     
% disp( ['Maximum absolute value of a component at the measured node: '...
%     , num2str(max(max(abs(sol_node))))]  );
% disp( ['Minimum absolute value of a component at the measured node: '...
%         , num2str(min(min(abs(sol_node))))]  );

end